/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.recipe.AbstractRecipe;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class FoodValuesDefinition
extends AbstractRecipe<Container> {
    private final Set<ResourceLocation> names;
    private final FoodValues foodValues;
    private final boolean item;

    public FoodValuesDefinition(ResourceLocation id, Set<ResourceLocation> names, FoodValues foodValues, boolean item) {
        super(id);
        this.names = ImmutableSet.copyOf(names);
        this.foodValues = foodValues;
        this.item = item;
    }

    public Set<ResourceLocation> getNames() {
        return this.names;
    }

    public FoodValues getFoodValues() {
        return this.foodValues;
    }

    public boolean isItem() {
        return this.item;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        ItemStack stack = pContainer.m_8020_(0);
        return this.item ? this.names.stream().anyMatch(name -> name.equals((Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()))) : this.names.stream().anyMatch(name -> stack.m_204117_(ItemTags.create((ResourceLocation)name)));
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public static FoodValues getFoodValues(ItemStack stack, Level level) {
        List allDefs = level.m_7465_().m_44056_((RecipeType)CrockPotRecipes.FOOD_VALUES_RECIPE_TYPE.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), level);
        if (allDefs.isEmpty()) {
            return FoodValues.create();
        }
        return allDefs.stream().filter(FoodValuesDefinition::isItem).findFirst().map(FoodValuesDefinition::getFoodValues).orElseGet(() -> {
            FoodValues foodValues = FoodValues.create();
            long maxCount = -1L;
            HashMap tagDefs = new HashMap();
            allDefs.forEach(def -> def.getNames().forEach(name -> tagDefs.put(name, def.getFoodValues())));
            for (ResourceLocation tag : stack.m_204131_().map(TagKey::f_203868_).filter(tagDefs::containsKey).toList()) {
                long count = tag.m_135815_().chars().filter(c -> c == 47).count();
                if (count < maxCount) continue;
                if (count > maxCount) {
                    maxCount = count;
                    foodValues.clear();
                }
                ((FoodValues)tagDefs.get(tag)).entrySet().forEach(entry -> foodValues.put((FoodCategory)((Object)((Object)((Object)entry.getKey()))), Math.max(foodValues.get((FoodCategory)((Object)((Object)((Object)entry.getKey())))), ((Float)entry.getValue()).floatValue())));
            }
            return foodValues;
        });
    }

    public static Set<ItemStack> getMatchedItems(FoodCategory category, Level level) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(Comparator.comparing(stack -> Float.valueOf(FoodValuesDefinition.getFoodValues(stack, level).get(category))).thenComparing(stack -> ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), Comparator.comparing(key -> !"minecraft".equals(key.m_135827_())).thenComparing(key -> !"crockpot".equals(key.m_135827_())).thenComparing(Comparator.naturalOrder())));
        List<FoodValuesDefinition> allDefs = level.m_7465_().m_44013_((RecipeType)CrockPotRecipes.FOOD_VALUES_RECIPE_TYPE.get()).stream().filter(def -> def.getFoodValues().has(category)).toList();
        allDefs.stream().filter(FoodValuesDefinition::isItem).forEach(itemDef -> itemDef.getNames().forEach(name -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(name);
            if (item != null && item != Items.f_41852_) {
                builder.add((Object)item.m_7968_());
            }
        }));
        allDefs.stream().filter(def -> !def.isItem()).forEach(tagDef -> tagDef.getNames().forEach(name -> {
            TagKey tag = ItemTags.create((ResourceLocation)name);
            if (ForgeRegistries.ITEMS.tags().isKnownTagName(tag)) {
                Ingredient.TagValue tagIngredient = new Ingredient.TagValue(tag);
                tagIngredient.m_6223_().forEach(stack -> {
                    if (FoodValuesDefinition.getFoodValues(stack, level).has(category)) {
                        builder.add(stack);
                    }
                });
            }
        }));
        return builder.build();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CrockPotRecipes.FOOD_VALUES_RECIPE_SERIALIZER.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)CrockPotRecipes.FOOD_VALUES_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<FoodValuesDefinition> {
        public FoodValuesDefinition fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            FoodValues foodValues = FoodValues.fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"values"));
            if (serializedRecipe.has("items") && serializedRecipe.has("tags")) {
                throw new JsonParseException("A food value definition entry needs either tags or items, not both");
            }
            if (serializedRecipe.has("items") || serializedRecipe.has("tags")) {
                HashSet<ResourceLocation> names = new HashSet<ResourceLocation>();
                boolean isItem = serializedRecipe.has("items");
                GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)(isItem ? "items" : "tags")).forEach(name -> names.add(new ResourceLocation(GsonHelper.m_13805_((JsonElement)name, (String)(isItem ? "item" : "tag")))));
                return new FoodValuesDefinition(recipeId, names, foodValues, isItem);
            }
            throw new JsonParseException("A food value definition entry needs either tags or items");
        }

        @Nullable
        public FoodValuesDefinition fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            boolean isItem = buffer.readBoolean();
            HashSet<ResourceLocation> names = new HashSet<ResourceLocation>();
            int length = buffer.m_130242_();
            for (int i = 0; i < length; ++i) {
                names.add(buffer.m_130281_());
            }
            FoodValues foodValues = FoodValues.fromNetwork(buffer);
            return new FoodValuesDefinition(recipeId, names, foodValues, isItem);
        }

        public void toNetwork(FriendlyByteBuf buffer, FoodValuesDefinition recipe) {
            buffer.writeBoolean(recipe.isItem());
            buffer.m_130130_(recipe.getNames().size());
            recipe.getNames().forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130085_(arg_0));
            recipe.getFoodValues().toNetwork(buffer);
        }
    }
}

